package mole.entities.particles 
{
	import mole.Main;
	import net.flashpunk.FP;

	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CParticleEmitter 
	{
		static public function RangeRandom(_fMin:Number, _fMax:Number):Number
		{
			//trace((((FP.random * _fMax) / _fMax) * (_fMax - _fMin)) + _fMin);
			return (((FP.random * _fMax) / _fMax) * (_fMax - _fMin)) + _fMin;
			//return _fMin + ((FP.random * (_fMax - _fMin)) + 1);
		}
		static public function GenerateParticlesAtPoint(_nPosX:int, _nPosY:int, _nType:int, _fLifeMin:Number, _fLifeMax:Number, _nNbParticles:int, _fDirXMin:Number, _fDirYMin:Number, _fDirXMax:Number, _fDirYMax:Number, _nVelocityMin:int, _nVelocityMax:int, _nLayer:int):void
		{
			var particle:CParticle = null;
			for (var i:int = 0; i < _nNbParticles; i++)
			{
				particle = new CParticle(RangeRandom(_fLifeMin, _fLifeMax), RangeRandom(_fDirXMin, _fDirXMax), RangeRandom(_fDirYMin, _fDirYMax), RangeRandom(_nVelocityMin, _nVelocityMax), _nType, RangeRandom(0.7, 1.3));
				particle.x = _nPosX;
				particle.y = _nPosY;
				particle.layer = _nLayer;
				Main.World.add(particle);
			}
		}
	}
}